﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Xml;
using System.Runtime.InteropServices;
using MenuAddCheckBox;
namespace RegularExpression
{
    public partial class RegTestForm : Form
    {
        public RegTestForm()
        {
            InitializeComponent();

            
            
            lcontxtmnStrip.Add(ToolStripCheckBoxMenuItem.newMenuStrip());
           
        }
        

        List<ContextMenuStrip> lcontxtmnStrip = new List<ContextMenuStrip>();
        private string txtName = "";

        public DataGridView DataGridview
        {
            get { return dataGridViews; }
        }
        public RichTextBox RichTxtBox
        {
            get { return richTextBox1; }
        }
        /// <summary>
        /// リッチテキストボックス内の全テキスト
        /// </summary>
        public string AllText
        {
            get { return richTextBox1.Text; }
            set { richTextBox1.Text = value; }
        }
        /// <summary>
        /// 選択開始位置
        /// </summary>
        public int SelStart
        {
            get { return richTextBox1.SelectionStart; }
            set { richTextBox1.SelectionStart = value; }
        }
        /// <summary>
        /// 選択した文字数
        /// </summary>
        public int SelLength
        {
            get { return richTextBox1.SelectionLength; }
            set { richTextBox1.SelectionLength = value; }
        }
        /// <summary>
        /// 選択されてる文字列
        /// </summary>
        public string SelText
        {
            get { return richTextBox1.SelectedText; }
            set { richTextBox1.SelectedText = value; }
        }
       
        private CheckColorRegstr[] SetReg()
        {
            int rowcount = dataGridViews.RowCount;

            if (rowcount <= 1)
                return null;
            CheckColorRegstr[] ccrs = new CheckColorRegstr[rowcount];
            for (int i = 0; i < ccrs.Length; i++)
            {
                ccrs[i] = new CheckColorRegstr();

                ccrs[i].Check = (bool)Check.DataGridView[1, i].FormattedValue;//(bool)dataGridViews[0, i].Value;
                ccrs[i].TxtColor = ColorButton.DataGridView[3, i].Style.BackColor;//(Color)dataGridViews[1, i].Value;
                ccrs[i].RegTxt = @"" + (string)RegString.DataGridView[4, i].Value;//(string)dataGridViews[2, i].Value;

            }
            return ccrs;
        }

        private void dataGridViews_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                if (0 == e.ColumnIndex)
                {
                    if (e.RowIndex >= 0)
                    dataGridViews.Rows.RemoveAt(e.RowIndex);
                }
                if (2 == e.ColumnIndex)
                {
                    if(e.RowIndex >=0)
                    lcontxtmnStrip[e.RowIndex].Show(Cursor.Position);
                }
                if (3 == e.ColumnIndex)
                {
                    if (e.RowIndex >= 0)
                    {
                        if (DialogResult.OK == colorDialog1.ShowDialog())
                        {
                            dataGridViews[e.ColumnIndex, e.RowIndex].Style.BackColor = colorDialog1.Color;
                            dataGridViews[e.ColumnIndex, e.RowIndex].Style.ForeColor = colorDialog1.Color;
                        }
                    }
                }
            }
            catch (InvalidOperationException ie)
            {
                MessageBox.Show(ie.Message);
                return;
            }
        }
        private RegexOptions GetRegexOption(int row)
        {
            RegexOptions rRegOp = RegexOptions.None;

            foreach (ToolStripItem tsi in lcontxtmnStrip[row].Items)
            {
                if (tsi == null)
                    continue;
                if (tsi.Text == "Compiled")
                {

                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.Compiled;
                }
                if (tsi.Text == "CultureInvariant")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.CultureInvariant;
                }
                if (tsi.Text == "ECMAScript")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.ECMAScript;
                }
                if (tsi.Text == "ExplicitCapture")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.ExplicitCapture;
                }
                if (tsi.Text == "IgnoreCase")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.IgnoreCase;
                }
                if (tsi.Text == "IgnorePatternWhitespace")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.IgnorePatternWhitespace;
                }
                if (tsi.Text == "Multiline")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.Multiline;
                }
                if (tsi.Text == "RightToLeft")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.RightToLeft;
                }
                if (tsi.Text == "Singleline")
                {
                    if (CheckState.Checked == (tsi as ToolStripCheckBoxMenuItem).checkState)
                        rRegOp |= RegexOptions.Singleline;

                }
            }
            
            
            return rRegOp;
                    
        }
        private void RegTestForm_Load(object sender, EventArgs e)
        {
            Save save = new Save();
            XmlSerializer serealize = new XmlSerializer(typeof(Save));
            try
            {
                FileStream fs = new FileStream("regs.xml", FileMode.Open);
                save = (Save)serealize.Deserialize(fs);
                dataGridViews.RowCount = save.regboolset.Length;
                for (int i = 0; i < dataGridViews.RowCount; i++)
                    lcontxtmnStrip.Add(ToolStripCheckBoxMenuItem.newMenuStrip());
                for (int i = 0; i < save.regboolset.Length; i++)
                {

                    Check.DataGridView[1, i].Value = save.regboolset[i];
                    if (save.regcolrset[i] == 0)
                    {
                        ColorButton.DataGridView[3, i].Style.BackColor = Color.FromArgb(-1);
                        ColorButton.DataGridView[3, i].Style.ForeColor = Color.FromArgb(-1);
                    }
                    else
                    {
                        ColorButton.DataGridView[3, i].Style.BackColor = Color.FromArgb(save.regcolrset[i]);
                        ColorButton.DataGridView[3, i].Style.ForeColor = Color.FromArgb(save.regcolrset[i]);
                    }
                    RegString.DataGridView[4, i].Value = save.regstrset[i];
                }
                fs.Close();
            }
            catch
            {
                return;
            }
            OpenRecentFile();
        }



        private void menuFileOpen_Click(object sender, EventArgs e)
        {
            if (richTextBox1.Modified)
            {
                int pos = richTextBox1.SelectionStart;
                if (txtName == "")
                {
                    DialogResult ret = MessageBox.Show("テキストボックス内容が変更されてます。\n保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            richTextBox1.Modified = false;
                            SaveAs_Click(sender, e);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
                else
                {
                    DialogResult ret = MessageBox.Show("ファイル" + txtName + "内容が変更されてます。\n上書き保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            richTextBox1.Modified = false;
                            menuSave_Click(sender, e);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
            }

            openFileDialog1.FileName = "";
            openFileDialog1.Filter = "テキスト文書 (*.txt)|*.txt|リッチテキスト文書 (*.rtf)|*.rtf|全ての文書(*.*)|*.*";
            openFileDialog1.RestoreDirectory = true;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                switch (openFileDialog1.FilterIndex)
                {
                    case 1:
                        richTextBox1.LoadFile(openFileDialog1.FileName, RichTextBoxStreamType.PlainText);
                        richTextBox1.Modified = false;
                        break;
                    case 2:
                        richTextBox1.LoadFile(openFileDialog1.FileName, RichTextBoxStreamType.RichText);
                        richTextBox1.Modified = false;
                        break;
                    case 3:
                        richTextBox1.LoadFile(openFileDialog1.FileName, RichTextBoxStreamType.UnicodePlainText);
                        richTextBox1.Modified = false;
                        break;
                }
                OpenFile(openFileDialog1.FileName);

            }

        }
        int row;
        private void button1_Click_1(object sender, EventArgs e)
        {
            CheckColorRegstr[] ccrs = SetReg();
            row = ccrs.Length;
            RegexOptions[] regOp = new RegexOptions[ccrs.Length]; //GetRegexOption();
            if (ccrs == null)
                return;
            Regex[] regexs = new Regex[ccrs.Length];
            for (int i = 0; i < ccrs.Length; i++)
            {
                regOp[i] = GetRegexOption(i);
                regexs[i] = new Regex(ccrs[i].RegTxt,regOp[i]);
                if (ccrs[i].Check == true)
                {
                    try
                    {

                        for (Match m = regexs[i].Match(richTextBox1.Text); m.Success; m = m.NextMatch())
                        {
                            if (ccrs[i].RegTxt != string.Empty && ccrs[i].RegTxt != "")
                            {
                                int spos = m.Index;
                                int len = ccrs[i].RegTxt.Length;
                                richTextBox1.Select(spos, m.Length);
                                richTextBox1.SelectionBackColor = Color.Transparent;
                                richTextBox1.SelectionColor = ccrs[i].TxtColor;

                            }

                        }
                    }
                    catch (ArgumentException ae)
                    {
                        MessageBox.Show(ae.Message);
                    }
                }
                else if (ccrs[i].Check == false)
                {
                    try
                    {

                        for (Match m = regexs[i].Match(richTextBox1.Text); m.Success; m = m.NextMatch())
                        {
                            if (ccrs[i].RegTxt != string.Empty && ccrs[i].RegTxt != "")
                            {
                                int spos = m.Index;

                                int len = ccrs[i].RegTxt.Length;
                                richTextBox1.Select(spos, m.Length);
                                richTextBox1.SelectionColor = Color.Black;
                                richTextBox1.SelectionBackColor = Color.Transparent;

                            }

                        }
                    }
                    catch (ArgumentException ae)
                    {
                        MessageBox.Show(ae.Message);
                    }
                }
            }



            richTextBox1.SelectionStart = richTextBox1.TextLength;
            richTextBox1.SelectionBackColor = Color.Transparent;
            richTextBox1.SelectionColor = Color.Black;
#if DEBUG
            for (int i = 0; i < ccrs.Length; i++)
            {
                Debug.WriteLine(ccrs[i].Check);
                Debug.WriteLine(ccrs[i].TxtColor);
                Debug.WriteLine(ccrs[i].RegTxt);
                Debug.WriteLine("");
            }
#endif

        }

        private void SaveRecentFiles()
        {
            string file = Application.StartupPath;

            file = Path.Combine(file, "recents.xml");

            XmlTextWriter xwr = new XmlTextWriter(file, Encoding.UTF8);

            xwr.WriteStartElement("files");

            for (int i = 0; i < mnuRecentFiles.DropDownItems.Count; i++)
            {
                ToolStripMenuItem current = (ToolStripMenuItem)mnuRecentFiles.DropDownItems[i];

                xwr.WriteStartElement("file");

                xwr.WriteString(current.Tag.ToString());

                xwr.WriteEndElement();
            }

            xwr.WriteEndElement();

            xwr.Flush();

            xwr.Close();
        }
        void AddRecent(string filename)
        {
            for (int i = 0; i < mnuRecentFiles.DropDownItems.Count; i++)
            {
                ToolStripMenuItem current = (ToolStripMenuItem)mnuRecentFiles.DropDownItems[i];

                if (current.Tag.ToString() == filename)
                {
                    mnuRecentFiles.DropDownItems.Remove(current);
                    break;
                }
            }

            if (mnuRecentFiles.DropDownItems.Count > 7)
            {
                for (int i = mnuRecentFiles.DropDownItems.Count - 1; i > 7; i--)
                {
                    mnuRecentFiles.DropDownItems.RemoveAt(i);
                }
            }

            ToolStripMenuItem item = new ToolStripMenuItem("1: " + Path.GetFileName(filename));
            item.Tag = filename;
            item.Click += new EventHandler(item_Click);

            mnuRecentFiles.DropDownItems.Insert(0, item);

            for (int i = 1; i < mnuRecentFiles.DropDownItems.Count; i++)
            {
                ToolStripMenuItem current = (ToolStripMenuItem)mnuRecentFiles.DropDownItems[i];

                current.Text = (i + 1).ToString() + ": " + Path.GetFileName(current.Tag.ToString());
            }
        }

        void item_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem item = (ToolStripMenuItem)sender;
            //txtName = item.Tag.ToString();
            this.OpenFile(item.Tag.ToString());
        }
        public void OpenFile(string filename)
        {
            Open(filename);

            AddRecent(filename);

        }
        public void Open(string filename)
        {
            if (richTextBox1.Modified)
            {
                int pos = richTextBox1.SelectionStart;
                if (txtName == "")
                {
                    DialogResult ret = MessageBox.Show("リッチテキストボックス内容が変更されてます。\n保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            richTextBox1.Modified = false;
                            SaveAs_Click(null, EventArgs.Empty);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
                else
                {
                    DialogResult ret = MessageBox.Show("ファイル" + txtName + "内容が変更されてます。\n上書き保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            richTextBox1.Modified = false;
                            menuSave_Click(null, EventArgs.Empty);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
            }
            try
            {
                string[] delims = filename.Split(new char[] { '.' });
                string delim = delims[delims.Length - 1];
                switch (delim)
                {
                    case "txt":
                        richTextBox1.Text = File.ReadAllText(filename, Encoding.Default);
                        richTextBox1.SelectAll();
                        richTextBox1.SelectionBackColor = Color.Transparent;
                        richTextBox1.SelectionColor = Color.Black;
                        richTextBox1.SelectionStart = richTextBox1.TextLength;
                        break;
                    case "rtf":
                        richTextBox1.LoadFile(filename, RichTextBoxStreamType.RichText);
                        richTextBox1.SelectionStart = richTextBox1.TextLength;
                        richTextBox1.SelectionBackColor = Color.Transparent;
                        richTextBox1.SelectionColor = Color.Black;

                        break;
                    default:
                        richTextBox1.Text = File.ReadAllText(filename, Encoding.Default);
                        richTextBox1.SelectAll();
                        richTextBox1.SelectionBackColor = Color.Transparent;
                        richTextBox1.SelectionColor = Color.Black;
                        richTextBox1.SelectionStart = richTextBox1.TextLength;
                        break;
                }
                richTextBox1.Modified = false;
                NowOpenTxt.Text = filename;
                NowOpenTxt.ToolTipText = filename;


                txtName = filename;

            }
            catch (IOException e)
            {
                MessageBox.Show(e.Message);
                return;
            }

        }
        private void OpenRecentFile()
        {
            string file = Application.StartupPath;
            file = Path.Combine(file, "recents.xml");

            if (!File.Exists(file))
                return;

            XmlTextReader xreader = new XmlTextReader(file);
            int index = 1;
            while (xreader.Read())
            {
                if (xreader.IsStartElement("file"))
                {
                    string path = xreader.ReadString();

                    ToolStripMenuItem item = new ToolStripMenuItem(index.ToString() + ": " + Path.GetFileName(path));

                    item.Tag = path;

                    item.Click += new EventHandler(item_Click);

                    mnuRecentFiles.DropDownItems.Add(item);

                    index++;
                }
            }

            xreader.Close();
        }

        private void MenuExit_Click(object sender, EventArgs e)
        {
            //this.SaveRecentFiles();
            this.Close();
        }
        /// <summary>
        /// 上書き保存
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void menuSave_Click(object sender, EventArgs e)
        {
            if (txtName != "")
            {
                try
                {
                    string[] delims = txtName.Split(new char[] { '.' });
                    string delim = delims[delims.Length - 1];
                    switch (delim)
                    {
                        case "txt":
                            richTextBox1.SaveFile(txtName, RichTextBoxStreamType.PlainText);
                            break;
                        case "rtf":
                            richTextBox1.SaveFile(txtName, RichTextBoxStreamType.RichText);
                            break;
                        default:
                            File.WriteAllText(txtName, richTextBox1.Text, Encoding.Default);
                            break;
                    }
                    richTextBox1.Modified = false;
                }
                catch (IOException ex)
                {
                    MessageBox.Show(ex.Message);
                    return;
                }

            }
            else
            {
                SaveAs_Click(sender, e);
            }

        }
        /// <summary>
        /// 名前を付けて保存
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void SaveAs_Click(object sender, EventArgs e)
        {

            saveFileDialog1.Filter = "テキスト文書 (*.txt)|*.txt|リッチテキスト文書 (*.rtf)|*.rtf|全ての文書(*.*)|*.*";
            saveFileDialog1.RestoreDirectory = true;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                FileStream fs = (FileStream)saveFileDialog1.OpenFile();
                switch (saveFileDialog1.FilterIndex)
                {
                    case 1:
                        richTextBox1.SaveFile(fs, RichTextBoxStreamType.PlainText);
                        break;
                    case 2:
                        richTextBox1.SaveFile(fs, RichTextBoxStreamType.RichText);
                        break;
                    case 3:
                        fs.Close();
                        File.WriteAllText(saveFileDialog1.FileName, richTextBox1.Text, Encoding.Default);
                        break;
                }
                if (fs != null)
                    fs.Close();
                richTextBox1.Modified = false;
                NowOpenTxt.Text = saveFileDialog1.FileName;
                NowOpenTxt.ToolTipText = saveFileDialog1.FileName;
                txtName = saveFileDialog1.FileName;

                AddRecent(saveFileDialog1.FileName);

            }
        }

        private void UnDo_Click(object sender, EventArgs e)
        {
            richTextBox1.Undo();
        }

        private void ReDu_Click(object sender, EventArgs e)
        {
            richTextBox1.Redo();
        }

        private void Cut_Click(object sender, EventArgs e)
        {
            if (richTextBox1.SelectionLength == 0)
            {
                MessageBox.Show("切り取る文字列がありません。");
                return;
            }
            richTextBox1.Cut();
        }

        private void Copy_Click(object sender, EventArgs e)
        {
            if (richTextBox1.SelectionLength == 0)
            {
                MessageBox.Show("コピーする文字列がありません。");
                return;
            }
            richTextBox1.Copy();
        }

        private void SelectAll_Click(object sender, EventArgs e)
        {
            richTextBox1.SelectAll();
        }

        private void Paste_Click(object sender, EventArgs e)
        {
            IDataObject clipData = Clipboard.GetDataObject();

            if (clipData.GetDataPresent(DataFormats.Text))
            {
                richTextBox1.Paste();
            }
            else if (clipData.GetDataPresent(DataFormats.Rtf))
            {
                richTextBox1.Paste();
            }
            else
            {
                MessageBox.Show("貼り付けられないデータです。");
            }
        }

        private void FindAndReplace_Click(object sender, EventArgs e)
        {
            FindReplaceForm frf = new FindReplaceForm();

            this.AddOwnedForm(frf);
            frf.frmMain = this;

            frf.Show();

        }

        private void RegTestForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (richTextBox1.Modified)
            {
                int pos = richTextBox1.SelectionStart;
                if (txtName == "")
                {
                    DialogResult ret = MessageBox.Show("リッチテキストボックス内容が変更されてます。\n保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            SaveAs_Click(sender, e);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
                else
                {
                    DialogResult ret = MessageBox.Show("ファイル" + txtName + "内容が変更されてます。\n上書き保存しますか？", "RichTextBox", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    switch (ret)
                    {
                        case DialogResult.Yes:
                            menuSave_Click(sender, e);
                            break;
                        case DialogResult.No:
                            break;
                        case DialogResult.Cancel:
                            richTextBox1.SelectionStart = pos;
                            break;
                    }
                }
            }
            this.SaveRecentFiles();
            Save save = new Save();
            CheckColorRegstr[] ccrs = SetReg();
            if (ccrs == null)
                return;
            List<bool> lb = new List<bool>();
            List<int> lc = new List<int>();
            List<string> ls = new List<string>();
            for (int i = 0; i < ccrs.Length; i++)
            {
                lb.Add(ccrs[i].Check);
                lc.Add(ccrs[i].TxtColor.ToArgb());
                ls.Add(ccrs[i].RegTxt);
            }
            save.regboolset = lb.ToArray();
            save.regcolrset = lc.ToArray();
            save.regstrset = ls.ToArray();
            lb.Clear();
            lc.Clear();
            ls.Clear();


            XmlSerializer serializer = new XmlSerializer(typeof(Save));
            FileStream fs = new FileStream("regs.xml", FileMode.Create);
            serializer.Serialize(fs, save);
            fs.Close();
        }

        private void NowOpenTxt_MouseHover(object sender, EventArgs e)
        {

        }
        void dataGridViews_RowsAdded(object sender, DataGridViewRowsAddedEventArgs e)
        {
            lcontxtmnStrip.Add(ToolStripCheckBoxMenuItem.newMenuStrip());
            
                
        }
        void dataGridViews_RowsRemoved(object sender, DataGridViewRowsRemovedEventArgs e)
        {
            lcontxtmnStrip.RemoveAt(e.RowIndex);
        }


    }
}